// content.js - Основной скрипт плагина для генерации доказательств
class AKeyPlugin {
    constructor() {
        this.init();
    }

    async init() {
        console.log('A-Pass Key Extension initializing...');
        this.setupEventListeners();
        this.setupWindowContext();
        console.log('A-Pass Key Extension ready');
    }

    setupEventListeners() {
        // Обработчик получения пользователя
        document.addEventListener('userGetRequest', async (event) => {
            const detail = event.detail;
            // console.log('Received userGetRequest detail:', detail);
            
            try {
                this.getBackgroundUser().then(result => {
                    // console.log(result);
                    window.postMessage({
                        type: 'APASS_KEY_RESULT',
                        result: result,
                        requestId: detail.requestId
                    }, '*');
                })
            } catch (error) {
                console.log(error);
            }
        });

        // Обработчик запросов от веб-страницы
        document.addEventListener('userUpdateRequest', async (event) => {
            const detail = event.detail;
            // console.log('Received userUpdateRequest detail:', detail);
            
            try {
                // Обновляем данные пользователя
                this.updateBackgroundUser(detail.userId, detail.userSecret).then(result => {
                    window.postMessage({
                        type: 'APASS_KEY_RESULT',
                        result: result,
                        requestId: detail.requestId
                    }, '*');
                });
            } catch (error) {
                console.error('Proof update failed:', error);
            }
        });

        // Обработчик генерации доказательства
        document.addEventListener('proofGetRequest', async (event) => {
            const detail = event.detail;
            // console.log('Received proofGetRequest detail:', detail);
            
            try {
                // Получаем доказательство
                this.generateBackgroundProof(detail.verifyId, detail.verifyHash, detail.verifyCode).then(result => {
                    // console.log(result);
                    window.postMessage({
                        type: 'APASS_KEY_RESULT',
                        result: result,
                        requestId: detail.requestId
                    }, '*');
                })
            } catch (error) {
                console.log(error);
            }
        });

    }
    setupWindowContext() {
        if (typeof window !== 'undefined') {
            // Отмечаем маркер в DOM
            const checkMarker = function() {
                const marker = document.getElementById('apass-key-check');
                if (marker) {
                    marker.setAttribute('data-extension-loaded', 'true');
                }
            };
            
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', checkMarker);
            } else {
                checkMarker();
            }
        }
    }

    async getBackgroundUser() {
        try {
            let response = await this.sendToBackground('getUser');
            // console.log(response);
            return response;
        } catch (error) {
            console.warn('Failed to get background proof:', error);
        }
    }

    async updateBackgroundUser(userId, userSecret) {
        try {
            let response = await this.sendToBackground('updateUser', { nodeId: 0, userId, userSecret });
            return response;
        } catch (error) {
            console.error('Failed to update background user:', error);
        }
    }

    async generateBackgroundProof(verifyId, verifyHash, verifyCode) {
        try {
            let response = await this.sendToBackground('generateProof', { verifyId, verifyHash, verifyCode } );
            // console.log(response);
            return response;
        } catch (error) {
            console.error('Failed to generate background proof:', error);
        }
    }

    async sendToBackground(action, data = null) {
        return new Promise((resolve, reject) => {
            chrome.runtime.sendMessage({ action, data }, (response) => {
                // console.log(response);
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                } else if (response && response.success) {
                    resolve(response);
                } else {
                    reject(new Error(response?.error || 'Background error'));
                }
            });
        });
    }
}

window.apassKeyPlugin = new AKeyPlugin();